/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.ammobench;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCount;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCountType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public final class AmmoBenchOutputModifier {
    private final SkillType<?> skill;
    private final boolean skillActive;
    private final AmmoBenchOutputCount outputCount;

    public AmmoBenchOutputModifier(SkillType<?> skill, boolean skillActive, AmmoBenchOutputCount outputCount) {
        this.skill = skill;
        this.skillActive = skillActive;
        this.outputCount = outputCount;
    }

    public boolean canApply(ISkillProvider skillProvider) {
        boolean hasSkill = skillProvider.hasSkill(this.skill);
        return this.skillActive == hasSkill;
    }

    public int getResultCount(int count) {
        return this.outputCount.getCount(count);
    }

    public AmmoBenchOutputCount getCountFunction() {
        return this.outputCount;
    }

    public static AmmoBenchOutputModifier parseJson(JsonElement element) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(element);
        ResourceLocation skillId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"skill"));
        SkillType type = (SkillType)ModRegistries.SKILLS.getValue(skillId);
        if (type == null) {
            throw new JsonSyntaxException("Unknown skill: " + skillId);
        }
        boolean required = JSONUtils.func_151209_a((JsonObject)object, (String)"active", (boolean)true);
        Object count = AmmoBenchOutputCountType.parseJson((JsonElement)JSONUtils.func_152754_s((JsonObject)object, (String)"modifier"));
        return new AmmoBenchOutputModifier(type, required, (AmmoBenchOutputCount)count);
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.skill.getRegistryName());
        buffer.writeBoolean(this.skillActive);
        AmmoBenchOutputCountType.toNetwork(this.outputCount, buffer);
    }

    public static AmmoBenchOutputModifier decode(PacketBuffer buffer) {
        ResourceLocation skillId = buffer.func_192575_l();
        SkillType skillType = (SkillType)ModRegistries.SKILLS.getValue(skillId);
        boolean active = buffer.readBoolean();
        Object count = AmmoBenchOutputCountType.fromNetwork(buffer);
        return new AmmoBenchOutputModifier(skillType, active, (AmmoBenchOutputCount)count);
    }
}

